/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge;

import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.bridge.ServiceRequest;
import com.ibm.hwmca.fw.util.Trace;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class OutgoingServiceRequest
extends ServiceRequest {
    private static final String TRACE_MASKT = "XNBRJORT";
    boolean responseComplete;
    IOException communicationError;
    NativeBridgeException responseError;

    public synchronized void waitForResponse() throws IOException, NativeBridgeException {
        Trace.trace(TRACE_MASKT, "Waiting for response from C code (to request id==" + this.requestId + ")");
        while (!this.responseComplete) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.communicationError != null) {
            this.communicationError.fillInStackTrace();
            Trace.trace(TRACE_MASKT, "Throwing exception describing communication error");
            Trace.trace(TRACE_MASKT, this.communicationError);
            throw this.communicationError;
        }
        if (this.responseError != null) {
            this.responseError.fillInStackTrace();
            Trace.trace(TRACE_MASKT, "Throwing exception describing Native Bridge error");
            Trace.trace(TRACE_MASKT, this.responseError);
            throw this.responseError;
        }
        Trace.trace(TRACE_MASKT, "Done waiting for response from C code (to request id==" + this.requestId + ")");
    }

    synchronized void setResponseComplete() {
        this.responseComplete = true;
        this.notifyAll();
    }

    synchronized void setResponseComplete(IOException e) {
        this.communicationError = e;
        this.responseComplete = true;
        this.notifyAll();
    }

    synchronized void setResponseComplete(NativeBridgeException e) {
        this.responseError = e;
        this.responseComplete = true;
        this.notifyAll();
    }

    protected synchronized void processFailedResponse(int errorCode, String errorMessage) {
        this.responseError = new NativeBridgeException(errorCode, errorMessage);
    }

    synchronized void setFailedResponseReturnCodes(int systemReturnCode, int componentReturnCode) {
        if (this.responseError != null) {
            this.responseError.setSystemAndComponentReturnCodes(systemReturnCode, componentReturnCode);
        }
    }

    protected abstract int getRequestCode();

    protected abstract void writeRequest(DataOutputStream var1) throws IOException;

    protected abstract void processSuccessfulResponse() throws IOException;
}

